IF NOT EXISTS(SELECT TOP 1 1 FROM INFORMATION_SCHEMA.TABLES
				WHERE TABLE_NAME='EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_BANDEIRA')
BEGIN
	SET ANSI_NULLS ON
	SET QUOTED_IDENTIFIER ON

	CREATE TABLE [EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_BANDEIRA](
		[CD_EMP] [int] NOT NULL CONSTRAINT [DF_EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_BANDEIRA_CD_EMP]  DEFAULT ((0)),
		[CD_ARV_PARAM] [int] NOT NULL CONSTRAINT [DF_EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_BANDEIRA_CD_ARV_PARAM]  DEFAULT ((0)),
		[CD_BANDEIRA] [int] NOT NULL CONSTRAINT [DF_EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_BANDEIRA_CD_BANDEIRA]  DEFAULT ((0)),
		[DT_CAD] [datetime] NULL CONSTRAINT [DF_EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_BANDEIRA_DT_CAD]  DEFAULT (getdate()),
		[CD_USU] [int] NOT NULL CONSTRAINT [DF_EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_BANDEIRA_CD_USU]  DEFAULT ((0)),
	 CONSTRAINT [PK_EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_BANDEIRA] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_ARV_PARAM] ASC,
		[CD_BANDEIRA] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 80) ON [PRIMARY]
	) ON [PRIMARY]
	  
	ALTER TABLE [EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_BANDEIRA]  
		WITH CHECK ADD  CONSTRAINT [FK_EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_BANDEIRA_EST_ARV_MD_F_GRP_PARAM_CURVA] 
		FOREIGN KEY([CD_EMP], [CD_ARV_PARAM])
	REFERENCES [EST_ARV_MD_F_GRP_PARAM_CURVA] ([CD_EMP], [CD_ARV_PARAM])
	ON UPDATE CASCADE
	ON DELETE CASCADE

	ALTER TABLE [EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_BANDEIRA] 
		CHECK CONSTRAINT [FK_EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_BANDEIRA_EST_ARV_MD_F_GRP_PARAM_CURVA]

	ALTER TABLE [EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_BANDEIRA]  
		WITH CHECK ADD  CONSTRAINT [FK_EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_BANDEIRA_PRC_BANDEIRA] 
		FOREIGN KEY([CD_BANDEIRA])
	REFERENCES [PRC_BANDEIRA] ([CD_BANDEIRA])
	ON UPDATE CASCADE

	ALTER TABLE [EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_BANDEIRA] 
		CHECK CONSTRAINT [FK_EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_BANDEIRA_PRC_BANDEIRA]

	ALTER TABLE [EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_BANDEIRA]  
		WITH CHECK ADD  CONSTRAINT [FK_EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_BANDEIRA_GLB_USU] 
		FOREIGN KEY([CD_USU])
	REFERENCES [GLB_USU] ([CD_USU])

	ALTER TABLE [EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_BANDEIRA] 
		CHECK CONSTRAINT [FK_EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_BANDEIRA_GLB_USU]

END